CREATE TABLE CRM_Mails (
	Id_Mail 		INT IDENTITY(1,1) NOT NULL,
	Id_Contacto		INT,
	Id_Email_Cuenta INT,
	Id_Cliente		INT,
	Id_Proveedor	INT,
    Id_Usuario 		SMALLINT,
    Creado			DATETIME,
    Enviado 		DATETIME,
	De	 			VARCHAR(120),
    A			 	VARCHAR(5000),
    CC 				VARCHAR(5000),
    BCC 			VARCHAR(5000),
    Asunto 			VARCHAR(255),
	CuerpoTexto 	TEXT,
    CuerpoHtml 		TEXT,
    Adjuntos 		VARCHAR(5000),
    Imagenes 		VARCHAR(5000),
    Estado 			INT 
)
GO

ALTER TABLE CRM_Mails ADD CONSTRAINT CML_PK_PorId PRIMARY KEY (Id_Mail)
GO

CREATE INDEX IX_CML_PorCont ON CRM_Mails (Id_Contacto,Creado)
GO
CREATE INDEX IX_CML_PorCuen ON CRM_Mails (Id_Email_Cuenta,Creado)
GO
CREATE INDEX IX_CML_PorCli ON CRM_Mails (Id_Cliente,Creado)
GO
CREATE INDEX IX_CML_PorPro ON CRM_Mails (Id_Proveedor,Creado)
GO
CREATE INDEX IX_CML_PorUser ON CRM_Mails (Id_Usuario,Creado)
GO

ALTER TABLE CRM_Mails ADD CONSTRAINT FK_CML_CRM_Contactos FOREIGN KEY (Id_Contacto) REFERENCES CRM_Contactos (Id_Contacto)
GO
ALTER TABLE CRM_Mails ADD CONSTRAINT FK_CML_CRM_Emails_Config FOREIGN KEY (Id_Email_Cuenta) REFERENCES Tab_Emails_Config (Id_Email)
GO
ALTER TABLE CRM_Mails ADD CONSTRAINT FK_CML_CRM_Clientes FOREIGN KEY (Id_Cliente) REFERENCES Clientes (Id_Cliente)
GO
ALTER TABLE CRM_Mails ADD CONSTRAINT FK_CML_CRM_Proveedores FOREIGN KEY (Id_Proveedor) REFERENCES Proveedores (Id_Proveedor)
GO
ALTER TABLE CRM_Mails ADD CONSTRAINT FK_CML_CRM_Usuarios FOREIGN KEY (Id_Usuario) REFERENCES Seg_User ([NO])
GO



